**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 Split by predicted
*02 test
*03 Based on nature when shock hit
*04 If ever constrained
*05 COSNTRAINED LAST YEAR



adopath + "P:\folder\Files\ado"
mata: mata mlib index

cd "P:\folder\Data"
use bas_final3.dta, clear



tsset firmid2 period

local hmax = 16

eststo clear 

cap drop b u d Years Zero
gen Years= _n-1 if _n<=`hmax'+1
g Zero=0 if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0


*** merging BCS data with the baseline sample - hads data on probablity cosntrained, and indicator whether ever constrained.
merge m:1 id tsid using "${intermediates}\risk_firm.dta", keep(master match)
compress

*********************01 Split by predicted - NOT used in paper due low preduction power

*** Large sampe - those wher use less variable in constraiend prediction regression

tsset firmid2 period
***INTENSIVE MARGIN
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largesampleq4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largesampleq3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largesampleq2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largesampleq1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

** extENSIVE MARGIN
eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largesampleq4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largesampleq3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largesampleq2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartlargefin==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largesampleq1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


****** smaller smaple

**** fin conditions with small sample

***INTENSIVE MARGIN

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallsampleq4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallsampleq3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallsampleq2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallsampleq1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


** extENSIVE margin
eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallsampleq4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallsampleq3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallsampleq2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if quartsmallfin==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallsampleq1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

*/


***02 test


** small sample
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.quartlargefin##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartlargefin==4 |  quartlargefin==1, cluster (period firmid2) a(i.quartlargefin##i.fsize_ i.quartlargefin##i.ind i.quartlargefin##i.qr)
}

estout * using "${results}\test_fincons_large_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.quartlargefin##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartlargefin==4 |  quartlargefin==1 , cluster (period firmid2) a(i.quartlargefin##i.fsize_ i.quartlargefin##i.ind i.quartlargefin##i.qr)
}


estout * using "${results}\test_fincoons_large_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)
*/


** small sample
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.quartsmallfin##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartsmallfin==4 |  quartsmallfin==1, cluster (period firmid2) a(i.quartsmallfin##i.fsize_ i.quartsmallfin##i.ind i.quartsmallfin##i.qr)
}

estout * using "${results}\test_fincons_small_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.quartsmallfin##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartsmallfin==4 |  quartsmallfin==1 , cluster (period firmid2) a(i.quartsmallfin##i.fsize_ i.quartsmallfin##i.ind i.quartsmallfin##i.qr)
}


estout * using "${results}\test_fincoons_small_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

******************************** Firm level constraint metrics


bysort id: egen max_hamper = max(hampofun_bcs) 

tsset firmid2 period

drop if max_hamper==.

***03 Based on nature when shock hit

** constr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if hampofun_bcs==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_constr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if hampofun_bcs==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_constr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



** noconstr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if hampofun_bcs==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_noconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if hampofun_bcs==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_noconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*********04 If ever constrained - preffered metric

** constr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if max_hamper==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_constr_ev.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if max_hamper==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_constr_ev.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



** noconstr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if max_hamper==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_noconstr_ev.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if max_hamper==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_noconstr_ev.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



***05 COSNTRAINED LAST YEAR

** constr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if l4.hampofun_bcs==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_lconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if l4.hampofun_bcs==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_lconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



** noconstr
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if l4.hampofun_bcs==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_lnoconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if l4.hampofun_bcs==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_lnoconstr.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


*/


*** test
/*

** curre cons
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.hampofun_bcs##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) , cluster (period firmid2) a(i.hampofun_bcs##i.fsize_ i.hampofun_bcs##i.ind i.hampofun_bcs##i.qr)
}

estout * using "${results}\test_fincons_hamp_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.hampofun_bcs##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)  , cluster (period firmid2) a(i.hampofun_bcs##i.fsize_ i.hampofun_bcs##i.ind i.hampofun_bcs##i.qr)
}


estout * using "${results}\test_fincoons_hamp_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


g prev_cons = l4.hampofun_bcs

** prev cons
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.prev_cons##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) , cluster (period firmid2) a(i.prev_cons##i.fsize_ i.prev_cons##i.ind i.prev_cons##i.qr)
}

estout * using "${results}\test_fincons_lhamp_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.prev_cons##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)  , cluster (period firmid2) a(i.prev_cons##i.fsize_ i.prev_cons##i.ind i.prev_cons##i.qr)
}


estout * using "${results}\test_fincoons_lhamp_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)





** ev cons
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.max_hamper##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) , cluster (period firmid2) a(i.max_hamper##i.fsize_ i.max_hamper##i.ind i.max_hamper##i.qr)
}

estout * using "${results}\test_fincons_evhamp_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.max_hamper##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)  , cluster (period firmid2) a(i.max_hamper##i.fsize_ i.max_hamper##i.ind i.max_hamper##i.qr)
}


estout * using "${results}\test_fincoons_evhamp_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

